#ifndef _PULSE_OXIMETER
#define _PULSE_OXIMETER


#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "PublicTypes.h"
#include "ADC.h"
#include "AverageFilter.h"
#include "SwTimer.h"
#include "TPM2.h"
#include "TpmPwm1.h"

//#define POX_DEBUG

/** ADC sampling period in ms */
#define POX_SAMPLING_PERIOD				1	//in ms

#ifdef POX_DEBUG
	#define POX_UPDATE_GRAPH_PERIOD			6	//in ms
#else
	#define POX_UPDATE_GRAPH_PERIOD			4	//in ms
#endif

/** ADC channel for pressure sensor output */
#define	POX_ADC_CHANNEL_OUTPUT_SIGNAL		8	//ADC channel number

/** ADC channel for heart beat signal */
#define	POX_ADC_CHANNEL_BASELINE_SIGNAL		0


#define	POX_REAL_TIME_DATA_ARRAY_LENGTH		64		//bytes

#define POX_ARRAY_LENGTH			8
#define OLDEST_ELEMENT				POX_ARRAY_LENGTH-1
#define NEWEST_ELEMENT				0



/* Switch control pin */
#define POX_SWITCH_CONTROL_PIN			PTDD_PTDD4
#define POX_SWITCH_CONTROL_PIN_DD		PTDDD_PTDDD4

#define POX_INIT_SWITCH_CONTROL_PIN()	POX_SWITCH_CONTROL_PIN_DD = 1
#define POX_SET_SWITCH_CONTROL(control)	 POX_SWITCH_CONTROL_PIN = control







/** Task that must be called periodically in tha main loop */
void  Pox_PeriodicTask(void);

/** Starts a Pox measurement 
	\returns TRUE if success, FALSE if already running */
UINT8 Pox_StartMeasurement(void);

/** Stops a Pox measurement */
void  Pox_AbortMeasurement(void);

/** Starts a Pox measurement 
	\returns TRUE if success, FALSE if already running */
UINT8 Pox_DiagnosticModeStartMeasurement(void);

/** Stops a Pox measurement */
void  Pox_DiagnosticModeStopMeasurement(void);


/** Call this function once before the main loop */
void Pox_Init(void);

/** Array of pointers to functions to execute Pox events */
extern const pFunc_t Pox_Events[];	

extern UINT8 Pox_HeartRate;
extern UINT8 Pox_SaturationValue;
extern UINT8 PoxGraph[];
extern UINT8 Pox_HeartBeatDetected;

/** These are the possible events that the Pox can generate */
typedef enum
{
	POX_EVENT_NONE,
	POX_EVENT_MEASUREMENT_COMPLETE_OK,
	POX_EVENT_MEASUREMENT_ERROR,
	POX_EVENT_NEW_DATA_READY,
	POX_EVENT_DEBUG_MODE_NEW_DATA_READY,
} Pox_Event_e;


/** Main Pox state machine states */
typedef enum
{
	POX_STATE_IDLE,
	POX_STATE_MEASURING	
} PoxStates_e;


#endif //_PULSE_OXIMETER